price_error_tian<-function(sigma){
  call<-numeric(nrow(call_AO_Tian))
  put<-numeric(nrow(put_AO_Tian))
  
  for(i in 1:nrow(call_AO_Tian)){
    call[i]<-BlackScholes(call_AO_Tian[i,6],call_AO_Tian[i,4],call_AO_Tian[i,8]*365,delta,call_AO_Tian[i,2]/365,sigma,"C")
  }
  for(i in 1:nrow(put_AO_Tian)){
    put[i]<-BlackScholes(put_AO_Tian[i,6],put_AO_Tian[i,4],put_AO_Tian[i,8]*365,delta,put_AO_Tian[i,2]/365,sigma,"P")
  }
  
  error<-0
  
  for(i in 1:nrow(call_AO_Tian)){
    error<-error+(call[i]-call_AO_Tian[i,7])^2
  }
  
  for (i in 1:nrow(put_AO_Tian)){
    error<-error+(put[i]-put_AO_Tian[i,7])^2
  }
  
  return(error)
}

price_error_tian_<-function(theta){
  
  # w1<-theta[1]
  # w2<-theta[2]
  # mu1<-theta[1]
  # mu2<-theta[2]
  # mu3<-theta[3]
  sigma1<-theta[1]
  sigma2<-theta[2]
  sigma3<-theta[3]
  pi1<-theta[4]
  pi2<-theta[5]
  pi3<-1-pi1-pi2
  
  call<-numeric(nrow(call_AO_Tian))
  put<-numeric(nrow(put_AO_Tian))
  
  for(i in 1:nrow(call_AO_Tian)){
    call[i]<-pi1*BlackScholes(call_AO_Tian[i,6],call_AO_Tian[i,4],call_AO_Tian[i,8]*365,delta,call_AO_Tian[i,2]/365,sigma1,"C")+pi2*BlackScholes(call_AO_Tian[i,6],call_AO_Tian[i,4],call_AO_Tian[i,8]*365,delta,call_AO_Tian[i,2]/365,sigma2,"C")+pi3*BlackScholes(call_AO_Tian[i,6],call_AO_Tian[i,4],call_AO_Tian[i,8]*365,delta,call_AO_Tian[i,2]/365,sigma3,"C")
  }
  for(i in 1:nrow(put_AO_Tian)){
    put[i]<-pi1*BlackScholes(put_AO_Tian[i,6],put_AO_Tian[i,4],call_AO_Tian[i,8]*365,delta,put_AO_Tian[i,2]/365,sigma1,"P")+pi2*BlackScholes(put_AO_Tian[i,6],put_AO_Tian[i,4],call_AO_Tian[i,8]*365,delta,put_AO_Tian[i,2]/365,sigma2,"P")+pi3*BlackScholes(put_AO_Tian[i,6],put_AO_Tian[i,4],call_AO_Tian[i,8]*365,delta,put_AO_Tian[i,2]/365,sigma3,"P")
  }
  
  error<-0
  
  for(i in 1:nrow(call_AO_Tian)){
    error<-error+(call[i]-call_AO_Tian[i,7])^2
  }
  
  for (i in 1:nrow(put_AO_Tian)){
    error<-error+(put[i]-put_AO_Tian[i,7])^2
  }
  
  return(error)
}


logitmax<-function(x,y){
  logitmax<-1/(1+exp(-5*(x-y)))
  return(logitmax)
}

maxapp<-function(x,y){
  maxapp<-logitmax(x,y)*x+(1-logitmax(x,y))*y
  return(maxapp)
}

CX<-function(w1,w2,mu1,mu2,mu3,sigma1,sigma2,sigma3,pi1,pi2,pi3,X,r,t){
  E0<-pi1*exp(mu1+sigma1^2/2)+pi2*exp(mu2+sigma2^2/2)+pi3*exp(mu3+sigma3^2/2)   #A-4:E[f_0]
  P1<-pi1*(1-pnorm((log(X)-mu1)/sigma1))+pi2*(1-pnorm((log(X)-mu2)/sigma2))+pi3*(1-pnorm((log(X)-mu3)/sigma3))    #A-5:Pr[f_0>=X]
  E1<-pi1*exp(mu1+sigma1^2/2)*(pnorm(-(log(X)-mu1-sigma1^2)/sigma1))/(1-pnorm((log(X)-mu1)/sigma1))+
    pi2*exp(mu2+sigma2^2/2)*(pnorm(-(log(X)-mu2-sigma2^2)/sigma2))/(1-pnorm((log(X)-mu2)/sigma2))+
    pi3*exp(mu3+sigma3^2/2)*(pnorm(-(log(X)-mu3-sigma3^2)/sigma3))/(1-pnorm((log(X)-mu3)/sigma3))    #A-7
  
  if (X<E0){
    w<-w1
  }else {
    w<-w2
  }
  CX<-w*((E1-X)*P1)+(1-w)*maxapp(E0-X,exp(-r*t)*(E1-X)*P1)
  return(CX)
}


PX<-function(w1,w2,mu1,mu2,mu3,sigma1,sigma2,sigma3,pi1,pi2,pi3,X,r,t){
  E0<-pi1*exp(mu1+sigma1^2/2)+pi2*exp(mu2+sigma2^2/2)+pi3*exp(mu3+sigma3^2/2)   #A-4:E[f_0]
  P2<-pi1*(pnorm((log(X)-mu1)/sigma1))+pi2*(pnorm((log(X)-mu2)/sigma2))+pi3*(pnorm((log(X)-mu3)/sigma3))    #A-6:Pr[f_0<=X]
  E2<-pi1*exp(mu1+sigma1^2/2)*pnorm((log(X)-mu1-sigma1^2)/sigma1)/(pnorm((log(X)-mu1)/sigma1))+
    pi2*exp(mu2+sigma2^2/2)*pnorm((log(X)-mu2-sigma2^2)/sigma2)/(pnorm((log(X)-mu2)/sigma2))+
    pi3*exp(mu3+sigma3^2/2)*pnorm((log(X)-mu3-sigma3^2)/sigma3)/(pnorm((log(X)-mu3)/sigma3))
  
  
  if (X>E0){
    w<-w1
  }else {
    w<-w2
  }
  PX<-w*((X-E2)*P2)+(1-w)*maxapp(X-E0,exp(-r*t)*(X-E2)*P2)
  return(PX)
}

price_error_Melick<-function(theta){
  w1<-theta[1]
  w2<-theta[2]
  mu1<-theta[3]
  mu2<-theta[4]
  mu3<-theta[5]
  sigma1<-theta[6]
  sigma2<-theta[7]
  sigma3<-theta[8]
  pi1<-theta[9]
  pi2<-theta[10]
  pi3<-1-pi1-pi2
  
  call<-numeric(nrow(call_AO_Melick))
  put<-numeric(nrow(put_AO_Melick))
  
  for(i in 1:nrow(call_AO_Melick)){
    call[i]<-CX(w1,w2,mu1,mu2,mu3,sigma1,sigma2,sigma3,pi1,pi2,pi3,call_AO_Melick[i,4],call_AO_Melick[i,8]*365,call_AO_Melick[i,3])
  }
  for(i in 1:nrow(put_AO_Melick)){
    put[i]<-PX(w1,w2,mu1,mu2,mu3,sigma1,sigma2,sigma3,pi1,pi2,pi3,put_AO_Melick[i,4],put_AO_Melick[i,8]*365,put_AO_Melick[i,3])
  }
  
  error<-0
  
  for(i in 1:nrow(call_AO_Melick)){
    error<-error+(call[i]-call_AO_Melick[i,7])^2
  }
  
  for (i in 1:nrow(call_AO_Melick)){
    error<-error+(put[i]-put_AO_Melick[i,7])^2
  }
  
  return(error)
}



price_error_Melick_<-function(theta){
  w1<-theta[1]
  w2<-theta[2]
  mu1<-theta[3]
  mu2<-theta[4]
  mu3<-theta[5]
  sigma1<-theta[6]
  sigma2<-theta[7]
  sigma3<-theta[8]
  pi1<-theta[9]
  pi2<-theta[10]
  pi3<-1-pi1-pi2
  
  call<-numeric(nrow(call_AO_Melick))
  put<-numeric(nrow(put_AO_Melick))
  
  for(i in 1:nrow(call_AO_Melick)){
    X<-call_AO_Melick[i,4]
    r<-call_AO_Melick[i,8]*365
    t<-call_AO_Melick[i,8]*365
    E0<-pi1*exp(mu1+sigma1^2/2)+pi2*exp(mu2+sigma2^2/2)+pi3*exp(mu3+sigma3^2/2)   #A-4:E[f_0]
    P1<-pi1*(1-pnorm((log(X)-mu1)/sigma1))+pi2*(1-pnorm((log(X)-mu2)/sigma2))+pi3*(1-pnorm((log(X)-mu3)/sigma3))    #A-5:Pr[f_0>=X]
    E1<-pi1*exp(mu1+sigma1^2/2)*(pnorm(-(log(X)-mu1-sigma1^2)/sigma1))/(1-pnorm((log(X)-mu1)/sigma1))+
      pi2*exp(mu2+sigma2^2/2)*(pnorm(-(log(X)-mu2-sigma2^2)/sigma2))/(1-pnorm((log(X)-mu2)/sigma2))+
      pi3*exp(mu3+sigma3^2/2)*(pnorm(-(log(X)-mu3-sigma3^2)/sigma3))/(1-pnorm((log(X)-mu3)/sigma3))    #A-7
    
    if (X<E0){
      w<-w1
    }else {
      w<-w2
    }
    call[i]<-w*((E1-X)*P1)+(1-w)*maxapp(E0-X,exp(-r*t)*(E1-X)*P1)
    
    #call[i]<-CX(w1,w2,mu1,mu2,mu3,sigma1,sigma2,sigma3,pi1,pi2,pi3,call_AO_Melick[i,4],call_AO_Melick[i,8]*365,call_AO_Melick[i,3])
  }
  for(i in 1:nrow(put_AO_Melick)){
    X<-put_AO_Melick[i,4]
    r<-put_AO_Melick[i,8]*365
    t<-put_AO_Melick[i,3]
    
    E0<-pi1*exp(mu1+sigma1^2/2)+pi2*exp(mu2+sigma2^2/2)+pi3*exp(mu3+sigma3^2/2)   #A-4:E[f_0]
    P2<-pi1*(pnorm((log(X)-mu1)/sigma1))+pi2*(pnorm((log(X)-mu2)/sigma2))+pi3*(pnorm((log(X)-mu3)/sigma3))    #A-6:Pr[f_0<=X]
    E2<-pi1*exp(mu1+sigma1^2/2)*pnorm((log(X)-mu1-sigma1^2)/sigma1)/(pnorm((log(X)-mu1)/sigma1))+
      pi2*exp(mu2+sigma2^2/2)*pnorm((log(X)-mu2-sigma2^2)/sigma2)/(pnorm((log(X)-mu2)/sigma2))+
      pi3*exp(mu3+sigma3^2/2)*pnorm((log(X)-mu3-sigma3^2)/sigma3)/(pnorm((log(X)-mu3)/sigma3))
    
    
    if (X>E0){
      w<-w1
    }else {
      w<-w2
    }
    
    put[i]<-w*((X-E2)*P2)+(1-w)*maxapp(X-E0,exp(-r*t)*(X-E2)*P2)
    
    
    #put[i]<-PX(w1,w2,mu1,mu2,mu3,sigma1,sigma2,sigma3,pi1,pi2,pi3,put_AO_Melick[i,4],put_AO_Melick[i,8]*365,put_AO_Melick[i,3])
  }
  
  error<-0
  
  for(i in 1:nrow(call_AO_Melick)){
    error<-error+(call[i]-call_AO_Melick[i,7])^2
  }
  
  for (i in 1:nrow(call_AO_Melick)){
    error<-error+(put[i]-put_AO_Melick[i,7])^2
  }
  
  return(error)
}




